%%
%% 《天文学进展》 - LaTeX Class File
%%
%% Copyright (c) 2025 latexstudio, website <www.latexstudio.net>, email <typeset@latexstudio.net>
%%
%% Author      : latexstudio
%% Website     : www.latexstudio.net
%% Email       : typeset@latexstudio.net
%% Date        : 2025-08-04 15:50:52
%% Description : 《天文学进展》 - LaTeX Class File
%%
%% This work may be distributed and/or modified under the terms of the
%% LaTeX Project Public License (LPPL), version 1.3c or later.
%% The latest version of this license is available at:
%%    http://www.latex-project.org/lppl.txt
%%
%% This work is maintained by latexstudio.
%%

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{twxjz-new}[2025/07/09, v1.0 by latexstudio.net]

\newcommand{\twxjz@version}{1.0}
\typeout{`TWXJZ' article document class V\twxjz@version, released 9 July 2025}

\newif\iftwxjz@dvips      \twxjz@dvipsfalse
\DeclareOption{dvips}{\twxjz@dvipstrue}
\DeclareOption{dvipdfm}{\twxjz@dvipsfalse}
\newif\iftwxjz@english    \twxjz@englishfalse
\DeclareOption{en}{\twxjz@englishtrue}
\DeclareOption{cn}{\twxjz@englishfalse}
\newif\iftwxjz@print      \twxjz@printtrue
\DeclareOption{Print}{\twxjz@printtrue}
\newif\iftwxjz@times      \twxjz@timestrue
\DeclareOption{notimes}{\twxjz@timesfalse}
\DeclareOption{screen}{\twxjz@printfalse}
\newif\iftwxjz@referee    \twxjz@refereefalse
\newif\iftwxjz@backmatter \twxjz@backmatterfalse
\DeclareOption{referee}{\twxjz@refereetrue}
\DeclareOption{final}{\twxjz@refereefalse}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{ctexart}}
\ProcessOptions\relax

\RequirePackage{ifthen,ifpdf}

\newif\ifctexversion\ctexversionfalse

\ifpdf
  \ifthenelse{\lengthtest{\the\pdftexversion\pdftexrevision pt > 14012 pt}}{\ctexversionfalse}{\ctexversiontrue}
\else
  \ifthenelse{\lengthtest{\the\XeTeXversion\XeTeXrevision pt > 0.9997 pt}}{\ctexversionfalse}{\ctexversiontrue}
\fi

\ifctexversion
  \LoadClass[a4paper,oneside,fancyhdr,c5size,adobefonts,fntef,UTF8]{ctexart}
  \ifpdf
    \usepackage{times}
  \else
    \setmainfont{Times New Roman}
  \fi
\else
  \LoadClass[a4paper,oneside,zihao={5},UTF8]{ctexart}
  \usepackage{fancyhdr}
  \usepackage{newtxtext,newtxmath}
  \defaultfontfeatures{}
  \let\Bbbk\relax
\fi

\ifpdf
  \RequirePackage[final]{graphicx}
  \RequirePackage{epstopdf}
\else
  \RequirePackage{graphicx}
  \RequirePackage{xeCJK}

\fi
\textwidth=148 mm
\textheight=215 mm

\RequirePackage{geometry}

\geometry{
left        = 25mm,     % 左边距：25mm（纸张→文本左边缘，不含页眉页脚影响）
  right       = 36.5mm,   % 右边距：36.5mm（纸张→文本右边缘）
  top         = 23mm,     % 上边距：23mm（纸张→页眉底部/文本顶部，包含页眉）
  bottom      = 58.5mm,   % 下边距：58.5mm（纸张→页脚顶部/文本底部，包含页脚）
  includehead = true,     % 核心：页眉算入上边距（top=23mm包含页眉）
  includefoot = true,     % 核心：页脚算入下边距（bottom=58.5mm包含页脚）
  headsep   = 5mm,
  footskip  = 2mm
}

\RequirePackage{
  amsfonts  , amsmath  , amssymb        , array    , booktabs , caption  ,
  enumitem  , fancyvrb , float          , multirow , pifont   , rotating ,
  subfigure , tabularx , threeparttable , upgreek  , url      , wrapfig
}

\RequirePackage{bm}
\RequirePackage{fp}

\RequirePackage[sort&compress,numbers,square]{natbib}
% \bibpunct{[}{]}{,}{s}{,}{\textsuperscript{,}}
% \bibliographystyle{twxjz}

\newcommand{\upcite}[1]{%
  \ifdim \f@size pt < 10.5pt%
    \FPeval{\scl@result}{\f@size / 10.5}%
    \scalebox{\scl@result}{\textsuperscript{\textsuperscript{\cite{#1}}}}%
  \else%
    \textsuperscript{\textsuperscript{\cite{#1}}}%
  \fi\hspace{0pt}%
}

\setlength{\@fptop}{0pt}
\newcolumntype{P}[1]{p{#1}<{\raggedright}}
\newcolumntype{C}[1]{p{#1}<{\centering}}
\newcolumntype{A}{@{\extracolsep{\fill}\hskip.5\tabcolsep}}
\renewcommand\baselinestretch{1.24}\selectfont
\bibsep .7pt plus .4pt minus .4pt
\renewcommand{\bibfont}{\footnotesize}
\urlstyle{same}
\setcounter{secnumdepth}{5}
\renewcommand{\floatpagefraction}{0.80}
\interfootnotelinepenalty=10000
\aboverulesep 1pt
\belowrulesep 1pt
\parskip 1pt
\setlist{nosep}
\parskip 0.12ex \@plus 0.0ex \@minus 0.0ex
\allowdisplaybreaks

% footnote
\RequirePackage[perpage]{footmisc}
\renewcommand{\thefootnote}{\ding{\numexpr191+\value{footnote}}}
\newcommand{\package}[1]{\texttt{#1}}

\captionsetup{
  labelsep = quad,
  font     = {bf,small},
}
\captionsetup[figure]{
  % belowskip     = -5pt,
  labelsep      = quad,
}
\captionsetup[table]{
  aboveskip     = 3pt,
  labelsep      = quad,
}

%% hyperref package
\ifctexversion
\else
  \ifpdf
    \RequirePackage[pdftex]{hyperref}

  \else
    \iftwxjz@dvips
      \RequirePackage[dvips]{hyperref}
    \else
      \RequirePackage{hyperref}
    \fi
      \AtBeginDvi{\special{pdf:tounicode GBK-EUC-UCS2}}
  \fi
  \hypersetup{
    bookmarksnumbered,
    colorlinks,
    linkcolor    = blue,
    citecolor    = blue,
    plainpages   = false,
    pdfstartview = FitH
  }
  \iftwxjz@print
      \hypersetup{colorlinks=false}
  \fi
\fi

\AtBeginDocument{
  \iftwxjz@english
      \iftwxjz@referee
          \def\baselinestretch{1.8}\selectfont
      \else
          \def\baselinestretch{1.3}\selectfont
      \fi
      \def\CTEX@figurename{Figure}
      \def\CTEX@tablename{Table}
      \def\CTEX@bibname{References}
      \def\CTEX@appendixname{Appendix\space}
      \def\acknowledgementsname{Acknowledgements}
      \def\indexname{Author Index}
  \else
      \iftwxjz@referee
          \def\baselinestretch{1.8}\selectfont
      \else
          \def\baselinestretch{1.25}\selectfont
      \fi
      \def\CTEX@appendixname{附录~}
      \def\acknowledgementsname{致谢}
      \renewcommand{\indexname}{作者索引}
  \fi
}

%%
%% Define some Command For TWXJZ
\def\c@en@abs@name{Abstract:}
\def\c@en@key@name{Key words:}
\def\c@cn@abs@name{摘要：}
\def\c@cn@key@name{关键词：}
\def\twxjz@doiname{doi: }
\def\twxjz@clcname{中图分类号：}
\def\twxjz@IDcodename{文献标识码：}
\def\twxjz@receive{收稿日期}
\def\twxjz@accept{修改日期}
\def\twxjz@chnjournalname{天文学进展}
\def\twxjz@engjournalname{PROGRESS IN ASTRONOMY}
\def\twxjz@publishvol{00}
\def\twxjz@publishnum{0}
\def\twxjz@publishyear{0000}
\gdef\twxjz@publishmonth{0}
\def\twxjz@doi{0000-0000}
\def\twxjz@clc{P000.0}
\def\twxjz@IDcode{X}

\newcommand\Volume[2]{%
  \renewcommand{\twxjz@publishvol}{#1}%
  \renewcommand{\twxjz@publishnum}{#2}%
}
\newcommand\PublishDate[2]{%
  \renewcommand{\twxjz@publishyear}{#1}%
  \gdef\twxjz@publishmonth{#2}%
}
\newcommand{\SerialNumber}[1]{\gdef\twxjz@doi{#1}}
\newcommand{\LabelNumber}[1]{\gdef\twxjz@clc{#1}}
\newcommand{\IDCode}[1]{\gdef\twxjz@IDcode{#1}}

%%
\newcommand{\twxjz@engmonth}[1]{%
  \ifcase#1 Month\or Jan.\or Feb.\or Mar.\or Apr.\or May\or June\or July\or
  Aug.\or Sept.\or Oct.\or Nov.\or Dec.\else Wronginput\fi}
%%
\newcommand{\timenow}{%
  \@tempcnta=\time \divide\@tempcnta by 60 \number\@tempcnta:\multiply
  \@tempcnta by 60 \@tempcntb=\time \advance\@tempcntb by -\@tempcnta
  \ifnum\@tempcntb <10 0\number\@tempcntb\else\number\@tempcntb\fi}

\renewcommand{\footnoterule}
    {\noindent\rule{10\ccwd}{0.45mm}\vspace{0.2cm}}
\setlength{\footnotesep}{12.65pt} %%

\let\@date\undefined
\let\support\relax

% \newcommand{\support}[1]{
%   \begingroup
%   \def\thefootnote{}% initial style
%   \protect\footnotetext[\c@footnote]{\ignorespaces#1}%
%   \endgroup\ignorespaces
% }
\renewcommand{\date}[2]{
  \begingroup
  \def\thefootnote{}    % initial style
  \protect\footnotetext[\c@footnote]{\ignorespaces{\heiti 收稿日期：} \ignorespaces#1~；\quad {\heiti 修回日期：} \ignorespaces#2}%
  \endgroup\ignorespaces
}

\newcommand{\support}[1]{
  \begingroup
  \def\thefootnote{}    % initial style
  \protect\footnotetext[\c@footnote]{\hangafter 1
  \hangindent  6.6em
  \ignorespaces{\heiti 资助项目：}~\ignorespaces#1}%
  \endgroup\ignorespaces
}

\newcommand{\corremail}[1]{
  \begingroup
  \def\thefootnote{}    % initial style
  \protect\footnotetext[\c@footnote]{\ignorespaces{\ziju{0.01}\heiti 通讯作者：}~\ignorespaces#1}%
  \endgroup\ignorespaces
}

\def\twxjz@titlemark{}
\newcommand\titlemark[1]{\def\twxjz@titlemark{#1}}

\gdef\title#1{\gdef\twxjz@title{#1}}
\gdef\author#1{\gdef\twxjz@author{#1}}

\def\inst#1{\unskip\textsuperscript{#1}}
\gdef\twxjz@institute{}
\newcommand{\institute}[1]{\gdef\twxjz@institute{#1}}

%% make title

\renewcommand\maketitle{
  \iftwxjz@english
    \@makeentitle
  \else
    \@makecntitle
  \fi
}

\def\@makecntitle{
  \pagestyle{main}
  \begingroup
  \parindent 0pt
  \iftwxjz@backmatter
    \vspace{15mm}
  \else
    \thispagestyle{twxjzheadings}
    \begingroup
      \vspace*{-6pt}%
      % \ifpdf
      % \vspace*{-2pt}
      % \else
      % \vspace*{4pt}
      % \fi
      \zihao{-5}\textbf{doi:}~10.3969/j.issn.1000-8349.\twxjz@doi
      \par
    \endgroup
  \vskip .8\baselineskip%
  \fi
    \begingroup
      \centering%
      {\bfseries\zihao{2}\heiti\twxjz@title\par}%
      \vskip \baselineskip%
      {\fangsong\zihao{-4} \twxjz@author\par}%
      \vskip \baselineskip%
      \iftwxjz@backmatter
        {\fangsong\zihao{6}\twxjz@institute\par}
      \else
        \begin{quote}
        \fangsong\zihao{6}\twxjz@institute\par
        \end{quote}
      \fi
      % \vskip .7\baselineskip%
    \endgroup
  \endgroup
  \setcounter{footnote}{0}
  \renewcommand{\thefootnote}{\ding{\numexpr191+\value{footnote}}}
}

\def\@makeentitle{
  \pagestyle{main}
  \begingroup
  \parindent 0pt
  \iftwxjz@backmatter
    \vspace{15mm}
  \else
    \thispagestyle{twxjzheadings}
    \begingroup
      \vspace*{-6pt}%
      % \ifpdf
      % \vspace*{-2pt}
      % \else
      % \vspace*{4pt}
      % \fi
      \zihao{-5}\textbf{doi:}~10.3969/j.issn.1000-8349.\twxjz@doi
      \par
    \endgroup
  \vskip .8\baselineskip%
  \fi
    \begingroup
      \centering%
      {\zihao{4}\bfseries\heiti\twxjz@title\par}%
      \vskip \baselineskip%
      {\zihao{5}\twxjz@author\par}%
      \vskip \baselineskip%
    \endgroup
      \iftwxjz@backmatter
        {\zihao{-5}\itshape\twxjz@institute\par}
      \else
        \begin{quote}
        \zihao{-5}\itshape\twxjz@institute\par
        \end{quote}
      \fi
      % \vskip .7\baselineskip%
  \endgroup
  \setcounter{footnote}{0}
  \renewcommand{\thefootnote}{\ding{\numexpr191+\value{footnote}}}
}

\let\abstract\relax
\let\endabstract\relax

\newenvironment{abstract}
{
\vspace{5mm}
\leftskip=2\ccwd \rightskip=2\ccwd
\noindent
\iftwxjz@english
  \zihao{-5}\textbf{\c@en@abs@name}~\ignorespaces
\else
  \zihao{-5}\textbf{\c@cn@abs@name}~\ignorespaces
\fi
}
{\iftwxjz@backmatter\else\noindent\textbf{\twxjz@clcname}~\twxjz@clc \quad \textbf{\twxjz@IDcodename}~\twxjz@IDcode\par\fi}

\newcommand\keywords[1]{%
  \vskip 0.5ex\noindent
  \hangafter 1
  \hangindent 5.4em
  \iftwxjz@english
    \zihao{-5}{\ziju{0.01}\textbf{\c@en@key@name}}~#1\par
  \else
    \zihao{-5}{\textbf{\c@cn@key@name}}~#1\par
  \fi
}

\AtBeginDocument{
\def\ps@twxjzheadings{
  \def\@evenhead{%
    \vbox{%
      \vskip 2pt%
      \hbox to \textwidth{\renewcommand{\arraystretch}{.86}\selectfont%
        \hbox{\quad\begin{tabular}[b]{@{}c@{}}\zihao{-5}第~\twxjz@publishvol~卷　第~\twxjz@publishnum~期\\\zihao{-5}\twxjz@publishyear~年~\twxjz@publishmonth~月\end{tabular}}%
        \hfill%
        \hbox{\begin{tabular}[b]{@{}c@{}}\ziju{1.16}\zihao{-4}\twxjz@chnjournalname\\\zihao{-5}\twxjz@engjournalname\end{tabular}}%
        \hfill%
        \hbox{\begin{tabular}[b]{@{}c@{}}\zihao{-5}Vol.\,\twxjz@publishvol,\ No.\,\twxjz@publishnum\\\zihao{-5}\twxjz@engmonth{\twxjz@publishmonth},\ \twxjz@publishyear\end{tabular}\quad}%
      }%
\vskip 2pt%
      \hrule width\textwidth height0.12 true mm\vskip1.5pt%
      \hrule width\textwidth height0.12 true mm\vskip0.85pt%
    }%
  }
  \let\@oddhead\@evenhead%
}

\fancypagestyle{main}{
  \fancyhf{}
  \fancyhead[R]{\zihao{-5}\ifodd\arabic{page}\relax\thepage\else \twxjz@publishvol{}~卷 \fi\quad}
  \fancyhead[C]{\zihao{-5}\ifodd\arabic{page}\relax\songti\zihao{-5}\ziju{0.01}\twxjz@titlemark\else\songti\zihao{-5}\ziju{0.6}\twxjz@chnjournalname\fi}
  \fancyhead[L]{\zihao{-5}\quad\ifodd\arabic{page}\relax\twxjz@publishnum{}~期\else\thepage\fi}
  \renewcommand{\headrulewidth}{1pt}
}

}

\def\refname{参考文献：}

\ifctexversion
  \CTEXsetup[
    format     = \zihao{4},
    number = {\arabic{section}},
    % beforeskip = 3.5ex \@plus 0.05ex\@minus 0.05ex,
    % afterskip  = 2.5ex  \@minus 0.05ex,
    % aftername  = \hskip .7em,
  ]{section}
  \CTEXsetup[
    format     = \bfseries\zihao{5},
    beforeskip = .1ex,
    afterskip  = .1ex,
    aftername  = \hskip .5em,
  ]{subsection}
  \CTEXsetup[
    format     = \zihao{5}\kaishu,
    beforeskip = .1ex,
    afterskip  = .1ex,
    aftername  = \hskip .5em,
  ]{subsubsection}
  \CTEXsetup[
    format     = \bfseries\normalsize,
    name       = {,)},
    number     = {\@arabic\c@paragraph},
    beforeskip = -.75ex \@plus -.25ex \@minus -.2ex,
    afterskip  = .2ex \@plus .1ex,
    aftername  = \hskip 1ex,
  ]{paragraph}
  \CTEXsetup[
    format     = \normalsize,
    name       = {(,)},
    number     = {\@alph\c@subparagraph},
    beforeskip = -.5ex \@plus -.25ex \@minus -.2ex,
    afterskip  = .1ex \@plus .1ex,
    aftername  = \hskip 1ex,
  ]{subparagraph}
  % \@ifpackageloaded{xeCJK}{
  %   \punctstyle{banjiao}
  %   \CJKsetecglue{}
  % }{}
\else

  \RequirePackage{xstring}
  \newcommand\twocharformat[1]{\StrLen{#1}[\temp]\ifnum \temp=2\ziju{1}#1\else#1\fi}

  \ctexset{
    section = {
      format     = \CTEXifname{\zihao{4}}{\heiti\zihao{5}},
      beforeskip = 3.5ex \@plus 0.05ex\@minus 0.05ex,
      titleformat = \CTEXifname{\twocharformat}{},
      afterskip  = 2.5ex  \@minus 0.05ex,
      aftername  = \hskip .7em,
    },
    subsection = {
      format     = \bfseries\zihao{5},
      beforeskip = .1ex,
      afterskip  = .1ex,
      aftername  = \hskip .5em,
    },
    subsubsection = {
      format     = \zihao{5}\kaishu,
      beforeskip = .1ex,
      afterskip  = .1ex,
      aftername  = \hskip .5em,
    },
    paragraph = {
      format     = \bfseries\normalsize,
      name       = {,)},
      number     = {\arabic{paragraph}},
      beforeskip = -.75ex \@plus -.25ex \@minus -.2ex,
      afterskip  = .2ex \@plus .1ex,
      aftername  = \hskip 1ex,
    },
    subparagraph = {
      format     = \normalsize,
      name       = {(,)},
      number     = {\alph{subparagraph}},
      beforeskip = -.5ex \@plus -.25ex \@minus -.2ex,
      afterskip  = .1ex \@plus .1ex,
      aftername  = \hskip 1ex,
    },
  }
  \renewcommand\bibsection{%
    \vspace*{.3em}
    \section*{\refname\@mkboth{\refname}{\refname}}%
    \vspace*{0em plus .4pt minus .4pt}
  }%
  % \@ifpackageloaded{xeCJK}{
  %   \xeCJKsetup{PunctStyle = banjiao}
  % }{}
\fi

\AtBeginEnvironment{tabular}{\small }
\AtBeginEnvironment{tabular*}{\small }

\def\backmatter{
  \iftwxjz@english
    \global\twxjz@englishfalse
  \else
    \global\twxjz@englishtrue
  \fi
  \twxjz@backmattertrue
}

% ====================================== define

%%
%% Astronomy and Astrophysics symbol macros
\newcommand\getsto{\mathrel{\mathchoice {\vcenter{\offinterlineskip
\halign{\hfil $\reset@font\displaystyle##$\hfil\cr\gets\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr\gets \cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr\gets \cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr \gets\cr\to\cr}}}}}

\newcommand\cor{\mathrel{\mathchoice {\hbox{$\widehat=$}}{\hbox{$\widehat=$}}
{\hbox{$\reset@font\scriptstyle\hat=$}} {\hbox{$\reset@font\scriptscriptstyle\hat=$}}}}

\newcommand\lid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr<\cr \noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr<\cr \noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr <\cr \noalign{\vskip0.9pt}=\cr}}}}}

\newcommand\gid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr>\cr \noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr>\cr \noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr
\noalign{\vskip0.9pt}=\cr}}}}}

\newcommand\sol{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr\sim\cr<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr\sim\cr <\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr\sim\cr <\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr \sim\cr<\cr}}}}}

\newcommand\sog{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr\sim\cr
>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr \sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr \sim\cr>\cr}}}}}

\newcommand\lse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr <\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr <\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr <\cr\simeq\cr}}}}}

\newcommand\gse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr\simeq\cr}}}}}

\newcommand\grole{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
>\cr\noalign{\vskip-1pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr\noalign{\vskip-0.5pt}<\cr}}}}}

\newcommand\leogr{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr <\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr <\cr\noalign{\vskip-1pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr <\cr\noalign{\vskip-0.5pt}>\cr}}}}}

\newcommand\loa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr <\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr <\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr <\cr\approx\cr}}}}}

\newcommand\goa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\reset@font\displaystyle##$\hfil\cr>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\textstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\reset@font\scriptscriptstyle##$\hfil\cr
>\cr\approx\cr}}}}}

\newcommand\sun{\hbox{$\odot$}}
\newcommand\earth{\hbox{$\oplus$}}
\newcommand\degr{\hbox{$^\circ$}}
\newcommand\diameter{{\ifmmode\mathchoice
{\ooalign{\hfil\hbox{$\reset@font\displaystyle/$}\hfil\crcr {\hbox{$\reset@font\displaystyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\reset@font\textstyle/$}\hfil\crcr {\hbox{$\reset@font\textstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\reset@font\scriptstyle/$}\hfil\crcr {\hbox{$\reset@font\scriptstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\reset@font\scriptscriptstyle/$}\hfil\crcr
{\hbox{$\reset@font\scriptscriptstyle\mathchar"20D$}}}}
\else{\ooalign{\hfil/\hfil\crcr\mathhexbox20D}}%
\fi}}

\newcommand\sq{\ifmmode\squareforqed\else{\unskip\nobreak\hfil
\penalty50\hskip1em\null\nobreak\hfil\squareforqed
\parfillskip=0pt\finalhyphendemerits=0\endgraf}\fi}
\newcommand\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}

\newcommand{\romn}[1] {{\mathrm #1}}

\newcommand\fd{\hbox{$.\!\!^{\reset@font\romn d}$}}
\newcommand\fh{\hbox{$.\!\!^{\reset@font\romn h}$}}
\newcommand\fm{\hbox{$.\!\!^{\reset@font\romn m}$}}
\newcommand\fs{\hbox{$.\!\!^{\reset@font\romn s}$}}
\newcommand\fdg{\hbox{$.\!\!^\circ$}}
\newcommand\farcm{\hbox{$.\mkern-4mu^\prime$}}
\newcommand\farcs{\hbox{$.\!\!^{\prime\prime}$}}
\newcommand\fp{\hbox{$.\!\!^{\reset@font\reset@font\scriptscriptstyle\romn p}$}}
\newcommand\arcmin{\hbox{$^\prime$}}
\newcommand\arcsec{\hbox{$^{\prime\prime}$}}

\def\micron{\hbox{$\umu$m}}

%====================================================================
% standard abbreviations of the mostly-used astro/astrophys-journals
%====================================================================
\let\jnl@style=\rmfamily
\def\ref@jnl#1{{\jnl@style#1}}%
\newcommand\aj{\ref@jnl{AJ}}%
          % Astronomical Journal
\newcommand\araa{\ref@jnl{ARA\&A}}%
          % Annual Review of Astron and Astrophys
\newcommand\apj{\ref@jnl{ApJ}}%
          % Astrophysical Journal
\newcommand\apjl{\ref@jnl{ApJL}}%
          % Astrophysical Journal, Letters
\newcommand\apjs{\ref@jnl{ApJS}}%
          % Astrophysical Journal, Supplement Series
\newcommand\ao{\ref@jnl{Appl~Opt}}%
          % Applied Optics
\newcommand\apss{\ref@jnl{Ap\&SS}}%
          % Astrophysics and Space Science
\newcommand\aap{\ref@jnl{A\&A}}%
          % Astronomy and Astrophysics
\newcommand\aapr{\ref@jnl{A\&A~Rev}}%
          % Astronomy and Astrophysics Reviews
\newcommand\aaps{\ref@jnl{A\&AS}}%
          % Astronomy and Astrophysics, Supplement Series
\newcommand\azh{\ref@jnl{AZh}}%
          % Astronomicheskii Zhurnal
\newcommand\baas{\ref@jnl{BAAS}}%
          % Bulletin of the AAS
\newcommand\chjaa{\ref@jnl{ChJAA}}
          % Chinese Journal Astronomy Astrophysics
\newcommand\ibvs{\ref@jnl{IBVS}}
          % Infoormation Bulletin on Variable Stars
\newcommand\jrasc{\ref@jnl{JRASC}}%
          % Journal of the RAS of Canada
\newcommand\memras{\ref@jnl{MmRAS}}%
          % Memoirs of the RAS
\newcommand\mnras{\ref@jnl{MNRAS}}%
          % Monthly Notices of the RAS
\newcommand\pra{\ref@jnl{Phys~Rev~A}}%
          % Physical Review A: General Physics
\newcommand\prb{\ref@jnl{Phys~Rev~B}}%
          % Physical Review B: Solid State
\newcommand\prc{\ref@jnl{Phys~Rev~C}}%
          % Physical Review C
\newcommand\prd{\ref@jnl{Phys~Rev~D}}%
          % Physical Review D
\newcommand\pre{\ref@jnl{Phys~Rev~E}}%
          % Physical Review E
\newcommand\prl{\ref@jnl{Phys~Rev~Lett}}%
          % Physical Review Letters
\newcommand\pasa{\ref@jnl{PASA}}%
\newcommand\pasp{\ref@jnl{PASP}}%
\newcommand\jcap{\ref@jnl{JCAP}}%
          % Publications of the ASP
\newcommand\pasj{\ref@jnl{PASJ}}%
          % Publications of the ASJ
\newcommand\qjras{\ref@jnl{QJRAS}}%
          % Quarterly Journal of the RAS
\newcommand\skytel{\ref@jnl{S\&T}}%
          % Sky and Telescope
\newcommand\solphys{\ref@jnl{Sol~Phys}}%
          % Solar Physics
\newcommand\sovast{\ref@jnl{Soviet~Ast}}%
          % Soviet Astronomy
\newcommand\ssr{\ref@jnl{Space~Sci~Rev}}%
          % Space Science Reviews
\newcommand\zap{\ref@jnl{ZAp}}%
          % Zeitschrift fuer Astrophysik
\newcommand\nat{\ref@jnl{Nature}}%
          % Nature
\newcommand\iaucirc{\ref@jnl{IAU~Circ}}%
          % IAU Cirulars
\newcommand\aplett{\ref@jnl{Astrophys~Lett}}%
          % Astrophysics Letters
\newcommand\apspr{\ref@jnl{Astrophys~Space~Phys~Res}}%
          % Astrophysics Space Physics Research
\newcommand\bain{\ref@jnl{Bull~Astron~Inst~Netherlands}}%
          % Bulletin Astronomical Institute of the Netherlands
\newcommand\fcp{\ref@jnl{Fund~Cosmic~Phys}}%
          % Fundamental Cosmic Physics
\newcommand\gca{\ref@jnl{Geochim~Cosmochim~Acta}}%
          % Geochimica Cosmochimica Acta
\newcommand\grl{\ref@jnl{Geophys~Res~Lett}}%
          % Geophysics Research Letters
\newcommand\jcp{\ref@jnl{J~Chem~Phys}}%
          % Journal of Chemical Physics
\newcommand\jgr{\ref@jnl{J~Geophys~Res}}%
          % Journal of Geophysics Research
\newcommand\jqsrt{\ref@jnl{J~Quant~Spec~Radiat~Transf}}%
          % Journal of Quantitiative Spectroscopy and Radiative Trasfer
\newcommand\memsai{\ref@jnl{Mem~Soc~Astron~Italiana}}%
          % Mem. Societa Astronomica Italiana
\newcommand\nphysa{\ref@jnl{Nucl~Phys~A}}%
          % Nuclear Physics A
\newcommand\physrep{\ref@jnl{Phys~Rep}}%
          % Physics Reports
\newcommand\physscr{\ref@jnl{Phys~Scr}}%
          % Physica Scripta
\newcommand\planss{\ref@jnl{Planet~Space~Sci}}%
          % Planetary Space Science
\newcommand\procspie{\ref@jnl{Proc~SPIE}}%
          % Proceedings of the SPIE
\newcommand\sci{\ref@jnl{Science}}
          % Science
\let\astap=\aap
\let\aas=\aaps
\let\apjlett=\apjl
\let\apjsupp=\apjs
\let\applopt=\ao
\newcommand\phn{\phantom{0}}%
\newcommand\phd{\phantom{.}}%
\newcommand\phs{\phantom{$-$}}%
\newcommand\phm[1]{\phantom{#1}}%

%============================================================
% Chinese astronomical affiliates:
%============================================================
\newcommand{\cas}{The Chinese Academy of Sciences}
\newcommand{\bao}{Beijing Astronomical Observatory,
Chinese Academy of Sciences, Beijing 100012}
\newcommand{\pmo}{{ Purple Mountain Observatory,  Chinese Academy of
          Sciences, Nanjing 210008}\\}
\newcommand{\sho}{{ Shanghai Observatory,  Chinese Academy of
          Sciences, Shanghai 200030}}
\newcommand{\yuo}{{ Yunnan Observatory,  Chinese Academy of
          Sciences, Kunming 650011}}
\newcommand{\ust}{{ Centre for Astrophysics, University of
          Sciences \& Technology of China, Hefei 230026}\\}
\newcommand{\ess}{{ Department of Earth and Space Sciences, University of
        Sciences \& Technology\\ of China, Hefei 230026}\\}
\newcommand{\gra}{{ Graduate School, University of Sciences
          \& Technology of China, Beijing 100039}\\}
\newcommand{\nua}{{ Department of Astronomy, Nanjing University,
          Nanjing 210008}\\}
\newcommand{\nnup}{{ Department of Physics, Nanjing Normal University,
          Nanjing 210097}\\}
\newcommand{\nup}{{ Department of Physics, Nanjing University,
          Nanjing 210008}\\}
\newcommand{\geo}{{ Department of Geophysics, Peking University,
          Beijing 100871}\\}
\newcommand{\phy}{{ Department of Physics, Peking University
         }}
\newcommand{\hep}{{ Institute of High Energy Physics, Chinese
          Academy of Sciences, Beijing 100039}\\}
\newcommand{\itp}{{ Institute of Theoretical Physics, Chinese
          Academy of Sciences, Beijing 100080}\\}
\newcommand{\bnua}{{ Department of Astronomy, Beijing Normal
          University, Beijing 100875}\\}
\newcommand{\bnup}{{ Department of Physics, Beijing Normal
          University, Beijing 100875}\\}
\newcommand{\sxo}{{ Shaanxi Observatory, The Chinese Academy of
          Sciences, Lintong 710600}\\}
\newcommand{\jlos}{{ Joint Laboratory for Optical Astronomy,
         The Chinese Academy of Sciences, Shanghai 200030}\\}
\newcommand{\jlrn}{{ Joint Laboratory for Radio Astronomy,
        The Chinese Academy of Sciences, Nanjing 210008}\\}
\newcommand{\css}{{ Center for Space Science and Applied
        Research, Beijing 100080}\\}
\newcommand{\rajl}{{ Radio Astronomy Joint Laboratory, Beijing,
        100080}\\}
\newcommand{\urum}{{ Urumqi Astronomical Station, Urumqi,
        830011}\\}
\newcommand{\jtap}{{ Department of Applied Physics, Shanghai Jiaotong
        University, Shanghai 200240}\\}
\newcommand{\ispa}{{ Institute of Space Physics and Astrophysics,
        Shanghai Jiaotong Univeristy, Shanghai 200030}\\}
\newcommand{\jbac}{{ CAS-Peking University Joint Beijing
        Astrophysical Center, Beijing 100871}\\}
\newcommand{\nao}{National Astronomical Observatories,
         Chinese Academy of Sciences, Beijing 100012}
\newcommand{\hua}{{ Department of Physics, Huazhong University of
         Science and Technology, Wuhan 430074}\\}
\newcommand{\iam}{{ Institute of Applied Mathematics, Chinese Academy of
         Sciences, Beijing 100080}\\}
\newcommand{\heb}{{ Department of Physics, Hebei Normal University,
         Shijiazhuang 050016}\\}

\endinput

%% End twxjz-new.cls


